/*
 * MATLAB Compiler: 3.0
 * Date: Mon Nov 03 13:00:57 2003
 * Arguments: "-B" "macro_default" "-O" "all" "-O" "fold_scalar_mxarrays:on"
 * "-O" "fold_non_scalar_mxarrays:on" "-O" "optimize_integer_for_loops:on" "-O"
 * "array_indexing:on" "-O" "optimize_conditionals:on" "-m" "-W" "main" "-L"
 * "C" "-t" "-T" "link:exe" "-h" "libmmfile.mlib" "DancingMonkeys" 
 */
#include "butter.h"
#include "bilinear.h"
#include "buttap.h"
#include "libmatlbm.h"
#include "libmmfile.h"
#include "lp2bp.h"
#include "lp2bs.h"
#include "lp2hp.h"
#include "lp2lp.h"
#include "signal_private_iirchk.h"
static mxArray * _mxarray0_;

static mxChar _array2_[23] = { 'F', 'i', 'l', 't', 'e', 'r', ' ', 'o',
                               'r', 'd', 'e', 'r', ' ', 't', 'o', 'o',
                               ' ', 'l', 'a', 'r', 'g', 'e', '.' };
static mxArray * _mxarray1_;
static mxArray * _mxarray3_;
static mxArray * _mxarray4_;
static mxArray * _mxarray5_;
static mxArray * _mxarray6_;
static mxArray * _mxarray7_;
static mxArray * _mxarray8_;
static mxArray * _mxarray9_;
static mxArray * _mxarray10_;
static mxArray * _mxarray11_;
static mxArray * _mxarray12_;

void InitializeModule_butter(void) {
    _mxarray0_ = mclInitializeDouble(500.0);
    _mxarray1_ = mclInitializeString(23, _array2_);
    _mxarray3_ = mclInitializeDouble(2.0);
    _mxarray4_ = mclInitializeDouble(3.141592653589793);
    _mxarray5_ = mclInitializeDoubleVector(0, 0, (double *)NULL);
    _mxarray6_ = mclInitializeDouble(1.0);
    _mxarray7_ = mclInitializeDouble(3.0);
    _mxarray8_ = mclInitializeDouble(4.0);
    _mxarray9_ = mclInitializeDouble(0.0);
    _mxarray10_ = mclInitializeComplex(-0.0, -1.0);
    _mxarray11_ = mclInitializeComplex(0.0, 1.0);
    _mxarray12_ = mclInitializeDouble(-1.0);
}

void TerminateModule_butter(void) {
    mxDestroyArray(_mxarray12_);
    mxDestroyArray(_mxarray11_);
    mxDestroyArray(_mxarray10_);
    mxDestroyArray(_mxarray9_);
    mxDestroyArray(_mxarray8_);
    mxDestroyArray(_mxarray7_);
    mxDestroyArray(_mxarray6_);
    mxDestroyArray(_mxarray5_);
    mxDestroyArray(_mxarray4_);
    mxDestroyArray(_mxarray3_);
    mxDestroyArray(_mxarray1_);
    mxDestroyArray(_mxarray0_);
}

static mxArray * mlfButter_buttnum(mxArray * btype,
                                   mxArray * n,
                                   mxArray * Wn,
                                   mxArray * Bw,
                                   mxArray * analog,
                                   mxArray * den);
static void mlxButter_buttnum(int nlhs,
                              mxArray * plhs[],
                              int nrhs,
                              mxArray * prhs[]);
static mxArray * mlfButter_buttzeros(mxArray * btype,
                                     mxArray * n,
                                     mxArray * Wn,
                                     mxArray * Bw,
                                     mxArray * analog);
static void mlxButter_buttzeros(int nlhs,
                                mxArray * plhs[],
                                int nrhs,
                                mxArray * prhs[]);
static mxArray * Mbutter(mxArray * * den,
                         mxArray * * z,
                         mxArray * * p,
                         int nargout_,
                         mxArray * n,
                         mxArray * Wn,
                         mxArray * varargin);
static mxArray * Mbutter_buttnum(int nargout_,
                                 mxArray * btype,
                                 mxArray * n,
                                 mxArray * Wn,
                                 mxArray * Bw,
                                 mxArray * analog,
                                 mxArray * den);
static mxArray * Mbutter_buttzeros(int nargout_,
                                   mxArray * btype,
                                   mxArray * n,
                                   mxArray * Wn,
                                   mxArray * Bw,
                                   mxArray * analog);

static mexFunctionTableEntry local_function_table_[2]
  = { { "buttnum", mlxButter_buttnum, 6, 1, NULL },
      { "buttzeros", mlxButter_buttzeros, 5, 1, NULL } };

_mexLocalFunctionTable _local_function_table_butter
  = { 2, local_function_table_ };

/*
 * The function "mlfNButter" contains the nargout interface for the "butter"
 * M-function from file "c:\matlab65\toolbox\signal\signal\butter.m" (lines
 * 1-115). This interface is only produced if the M-function uses the special
 * variable "nargout". The nargout interface allows the number of requested
 * outputs to be specified via the nargout argument, as opposed to the normal
 * interface which dynamically calculates the number of outputs based on the
 * number of non-NULL inputs it receives. This function processes any input
 * arguments and passes them to the implementation version of the function,
 * appearing above.
 */
mxArray * mlfNButter(int nargout,
                     mxArray * * den,
                     mxArray * * z,
                     mxArray * * p,
                     mxArray * n,
                     mxArray * Wn,
                     ...) {
    mxArray * varargin = NULL;
    mxArray * num = NULL;
    mxArray * den__ = NULL;
    mxArray * z__ = NULL;
    mxArray * p__ = NULL;
    mlfVarargin(&varargin, Wn, 0);
    mlfEnterNewContext(3, -3, den, z, p, n, Wn, varargin);
    num = Mbutter(&den__, &z__, &p__, nargout, n, Wn, varargin);
    mlfRestorePreviousContext(3, 2, den, z, p, n, Wn);
    mxDestroyArray(varargin);
    if (den != NULL) {
        mclCopyOutputArg(den, den__);
    } else {
        mxDestroyArray(den__);
    }
    if (z != NULL) {
        mclCopyOutputArg(z, z__);
    } else {
        mxDestroyArray(z__);
    }
    if (p != NULL) {
        mclCopyOutputArg(p, p__);
    } else {
        mxDestroyArray(p__);
    }
    return mlfReturnValue(num);
}

/*
 * The function "mlfButter" contains the normal interface for the "butter"
 * M-function from file "c:\matlab65\toolbox\signal\signal\butter.m" (lines
 * 1-115). This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
mxArray * mlfButter(mxArray * * den,
                    mxArray * * z,
                    mxArray * * p,
                    mxArray * n,
                    mxArray * Wn,
                    ...) {
    mxArray * varargin = NULL;
    int nargout = 1;
    mxArray * num = NULL;
    mxArray * den__ = NULL;
    mxArray * z__ = NULL;
    mxArray * p__ = NULL;
    mlfVarargin(&varargin, Wn, 0);
    mlfEnterNewContext(3, -3, den, z, p, n, Wn, varargin);
    if (den != NULL) {
        ++nargout;
    }
    if (z != NULL) {
        ++nargout;
    }
    if (p != NULL) {
        ++nargout;
    }
    num = Mbutter(&den__, &z__, &p__, nargout, n, Wn, varargin);
    mlfRestorePreviousContext(3, 2, den, z, p, n, Wn);
    mxDestroyArray(varargin);
    if (den != NULL) {
        mclCopyOutputArg(den, den__);
    } else {
        mxDestroyArray(den__);
    }
    if (z != NULL) {
        mclCopyOutputArg(z, z__);
    } else {
        mxDestroyArray(z__);
    }
    if (p != NULL) {
        mclCopyOutputArg(p, p__);
    } else {
        mxDestroyArray(p__);
    }
    return mlfReturnValue(num);
}

/*
 * The function "mlfVButter" contains the void interface for the "butter"
 * M-function from file "c:\matlab65\toolbox\signal\signal\butter.m" (lines
 * 1-115). The void interface is only produced if the M-function uses the
 * special variable "nargout", and has at least one output. The void interface
 * function specifies zero output arguments to the implementation version of
 * the function, and in the event that the implementation version still returns
 * an output (which, in MATLAB, would be assigned to the "ans" variable), it
 * deallocates the output. This function processes any input arguments and
 * passes them to the implementation version of the function, appearing above.
 */
void mlfVButter(mxArray * n, mxArray * Wn, ...) {
    mxArray * varargin = NULL;
    mxArray * num = NULL;
    mxArray * den = NULL;
    mxArray * z = NULL;
    mxArray * p = NULL;
    mlfVarargin(&varargin, Wn, 0);
    mlfEnterNewContext(0, -3, n, Wn, varargin);
    num = Mbutter(&den, &z, &p, 0, n, Wn, varargin);
    mlfRestorePreviousContext(0, 2, n, Wn);
    mxDestroyArray(varargin);
    mxDestroyArray(num);
    mxDestroyArray(den);
    mxDestroyArray(z);
}

/*
 * The function "mlxButter" contains the feval interface for the "butter"
 * M-function from file "c:\matlab65\toolbox\signal\signal\butter.m" (lines
 * 1-115). The feval function calls the implementation version of butter
 * through this function. This function processes any input arguments and
 * passes them to the implementation version of the function, appearing above.
 */
void mlxButter(int nlhs, mxArray * plhs[], int nrhs, mxArray * prhs[]) {
    mxArray * mprhs[3];
    mxArray * mplhs[4];
    int i;
    if (nlhs > 4) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: butter Line: 1 Column: "
            "1 The function \"butter\" was called with mor"
            "e than the declared number of outputs (4)."),
          NULL);
    }
    for (i = 0; i < 4; ++i) {
        mplhs[i] = NULL;
    }
    for (i = 0; i < 2 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 2; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(0, 2, mprhs[0], mprhs[1]);
    mprhs[2] = NULL;
    mlfAssign(&mprhs[2], mclCreateVararginCell(nrhs - 2, prhs + 2));
    mplhs[0]
      = Mbutter(
          &mplhs[1], &mplhs[2], &mplhs[3], nlhs, mprhs[0], mprhs[1], mprhs[2]);
    mlfRestorePreviousContext(0, 2, mprhs[0], mprhs[1]);
    plhs[0] = mplhs[0];
    for (i = 1; i < 4 && i < nlhs; ++i) {
        plhs[i] = mplhs[i];
    }
    for (; i < 4; ++i) {
        mxDestroyArray(mplhs[i]);
    }
    mxDestroyArray(mprhs[2]);
}

/*
 * The function "mlfButter_buttnum" contains the normal interface for the
 * "butter/buttnum" M-function from file
 * "c:\matlab65\toolbox\signal\signal\butter.m" (lines 115-157). This function
 * processes any input arguments and passes them to the implementation version
 * of the function, appearing above.
 */
static mxArray * mlfButter_buttnum(mxArray * btype,
                                   mxArray * n,
                                   mxArray * Wn,
                                   mxArray * Bw,
                                   mxArray * analog,
                                   mxArray * den) {
    int nargout = 1;
    mxArray * b = NULL;
    mlfEnterNewContext(0, 6, btype, n, Wn, Bw, analog, den);
    b = Mbutter_buttnum(nargout, btype, n, Wn, Bw, analog, den);
    mlfRestorePreviousContext(0, 6, btype, n, Wn, Bw, analog, den);
    return mlfReturnValue(b);
}

/*
 * The function "mlxButter_buttnum" contains the feval interface for the
 * "butter/buttnum" M-function from file
 * "c:\matlab65\toolbox\signal\signal\butter.m" (lines 115-157). The feval
 * function calls the implementation version of butter/buttnum through this
 * function. This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
static void mlxButter_buttnum(int nlhs,
                              mxArray * plhs[],
                              int nrhs,
                              mxArray * prhs[]) {
    mxArray * mprhs[6];
    mxArray * mplhs[1];
    int i;
    if (nlhs > 1) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: butter/buttnum Line: 115 Colu"
            "mn: 1 The function \"butter/buttnum\" was called wi"
            "th more than the declared number of outputs (1)."),
          NULL);
    }
    if (nrhs > 6) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: butter/buttnum Line: 115 Colu"
            "mn: 1 The function \"butter/buttnum\" was called wi"
            "th more than the declared number of inputs (6)."),
          NULL);
    }
    for (i = 0; i < 1; ++i) {
        mplhs[i] = NULL;
    }
    for (i = 0; i < 6 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 6; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(
      0, 6, mprhs[0], mprhs[1], mprhs[2], mprhs[3], mprhs[4], mprhs[5]);
    mplhs[0]
      = Mbutter_buttnum(
          nlhs, mprhs[0], mprhs[1], mprhs[2], mprhs[3], mprhs[4], mprhs[5]);
    mlfRestorePreviousContext(
      0, 6, mprhs[0], mprhs[1], mprhs[2], mprhs[3], mprhs[4], mprhs[5]);
    plhs[0] = mplhs[0];
}

/*
 * The function "mlfButter_buttzeros" contains the normal interface for the
 * "butter/buttzeros" M-function from file
 * "c:\matlab65\toolbox\signal\signal\butter.m" (lines 157-187). This function
 * processes any input arguments and passes them to the implementation version
 * of the function, appearing above.
 */
static mxArray * mlfButter_buttzeros(mxArray * btype,
                                     mxArray * n,
                                     mxArray * Wn,
                                     mxArray * Bw,
                                     mxArray * analog) {
    int nargout = 1;
    mxArray * z = NULL;
    mlfEnterNewContext(0, 5, btype, n, Wn, Bw, analog);
    z = Mbutter_buttzeros(nargout, btype, n, Wn, Bw, analog);
    mlfRestorePreviousContext(0, 5, btype, n, Wn, Bw, analog);
    return mlfReturnValue(z);
}

/*
 * The function "mlxButter_buttzeros" contains the feval interface for the
 * "butter/buttzeros" M-function from file
 * "c:\matlab65\toolbox\signal\signal\butter.m" (lines 157-187). The feval
 * function calls the implementation version of butter/buttzeros through this
 * function. This function processes any input arguments and passes them to the
 * implementation version of the function, appearing above.
 */
static void mlxButter_buttzeros(int nlhs,
                                mxArray * plhs[],
                                int nrhs,
                                mxArray * prhs[]) {
    mxArray * mprhs[5];
    mxArray * mplhs[1];
    int i;
    if (nlhs > 1) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: butter/buttzeros Line: 157 Col"
            "umn: 1 The function \"butter/buttzeros\" was called "
            "with more than the declared number of outputs (1)."),
          NULL);
    }
    if (nrhs > 5) {
        mlfError(
          mxCreateString(
            "Run-time Error: File: butter/buttzeros Line: 157 Col"
            "umn: 1 The function \"butter/buttzeros\" was called "
            "with more than the declared number of inputs (5)."),
          NULL);
    }
    for (i = 0; i < 1; ++i) {
        mplhs[i] = NULL;
    }
    for (i = 0; i < 5 && i < nrhs; ++i) {
        mprhs[i] = prhs[i];
    }
    for (; i < 5; ++i) {
        mprhs[i] = NULL;
    }
    mlfEnterNewContext(0, 5, mprhs[0], mprhs[1], mprhs[2], mprhs[3], mprhs[4]);
    mplhs[0]
      = Mbutter_buttzeros(
          nlhs, mprhs[0], mprhs[1], mprhs[2], mprhs[3], mprhs[4]);
    mlfRestorePreviousContext(
      0, 5, mprhs[0], mprhs[1], mprhs[2], mprhs[3], mprhs[4]);
    plhs[0] = mplhs[0];
}

/*
 * The function "Mbutter" is the implementation version of the "butter"
 * M-function from file "c:\matlab65\toolbox\signal\signal\butter.m" (lines
 * 1-115). It contains the actual compiled code for that M-function. It is a
 * static function and must only be called from one of the interface functions,
 * appearing below.
 */
/*
 * function [num, den, z, p] = butter(n, Wn, varargin)
 */
static mxArray * Mbutter(mxArray * * den,
                         mxArray * * z,
                         mxArray * * p,
                         int nargout_,
                         mxArray * n,
                         mxArray * Wn,
                         mxArray * varargin) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_butter);
    mxArray * num = NULL;
    mxArray * d = NULL;
    mxArray * c = NULL;
    mxArray * b = NULL;
    mxArray * a = NULL;
    mxArray * k = NULL;
    mxArray * Bw = NULL;
    mxArray * u = NULL;
    mxArray * fs = NULL;
    mxArray * ans = NULL;
    mxArray * errStr = NULL;
    mxArray * analog = NULL;
    mxArray * btype = NULL;
    mclCopyArray(&n);
    mclCopyArray(&Wn);
    mclCopyArray(&varargin);
    /*
     * %BUTTER Butterworth digital and analog filter design.
     * %   [B,A] = BUTTER(N,Wn) designs an Nth order lowpass digital
     * %   Butterworth filter and returns the filter coefficients in length 
     * %   N+1 vectors B (numerator) and A (denominator). The coefficients 
     * %   are listed in descending powers of z. The cutoff frequency 
     * %   Wn must be 0.0 < Wn < 1.0, with 1.0 corresponding to 
     * %   half the sample rate.
     * %
     * %   If Wn is a two-element vector, Wn = [W1 W2], BUTTER returns an 
     * %   order 2N bandpass filter with passband  W1 < W < W2.
     * %   [B,A] = BUTTER(N,Wn,'high') designs a highpass filter.
     * %   [B,A] = BUTTER(N,Wn,'stop') is a bandstop filter if Wn = [W1 W2].
     * %   
     * %   When used with three left-hand arguments, as in
     * %   [Z,P,K] = BUTTER(...), the zeros and poles are returned in
     * %   length N column vectors Z and P, and the gain in scalar K. 
     * %
     * %   When used with four left-hand arguments, as in
     * %   [A,B,C,D] = BUTTER(...), state-space matrices are returned.
     * %
     * %   BUTTER(N,Wn,'s'), BUTTER(N,Wn,'high','s') and BUTTER(N,Wn,'stop','s')
     * %   design analog Butterworth filters.  In this case, Wn is in [rad/s]
     * %   and it can be greater than 1.0.
     * %
     * %   See also BUTTORD, BESSELF, CHEBY1, CHEBY2, ELLIP, FREQZ, FILTER.
     * 
     * %   Author(s): J.N. Little, 1-14-87
     * %   	   J.N. Little, 1-14-88, revised
     * %   	   L. Shure, 4-29-88, revised
     * %   	   T. Krauss, 3-24-93, revised
     * %   Copyright 1988-2002 The MathWorks, Inc.
     * %   $Revision: 1.8 $  $Date: 2002/03/28 17:27:10 $
     * 
     * %   References:
     * %     [1] T. W. Parks and C. S. Burrus, Digital Filter Design,
     * %         John Wiley & Sons, 1987, chapter 7, section 7.3.3.
     * 
     * [btype,analog,errStr] = iirchk(Wn,varargin{:});
     */
    mlfAssign(
      &btype,
      mlfSignal_private_iirchk(
        &analog,
        &errStr,
        mclVa(Wn, "Wn"),
        mlfIndexRef(mclVa(varargin, "varargin"), "{?}", mlfCreateColonIndex()),
        NULL));
    /*
     * error(errStr)
     */
    mlfError(mclVv(errStr, "errStr"), NULL);
    /*
     * 
     * if n>500
     */
    if (mclGtBool(mclVa(n, "n"), _mxarray0_)) {
        /*
         * error('Filter order too large.')
         */
        mlfError(_mxarray1_, NULL);
    /*
     * end
     */
    }
    /*
     * 
     * % step 1: get analog, pre-warped frequencies
     * if ~analog,
     */
    if (mclNotBool(mclVv(analog, "analog"))) {
        /*
         * fs = 2;
         */
        mlfAssign(&fs, _mxarray3_);
        /*
         * u = 2*fs*tan(pi*Wn/fs);
         */
        mlfAssign(
          &u,
          mclMtimes(
            mclMtimes(_mxarray3_, mclVv(fs, "fs")),
            mlfTan(
              mclMrdivide(
                mclMtimes(_mxarray4_, mclVa(Wn, "Wn")), mclVv(fs, "fs")))));
    /*
     * else
     */
    } else {
        /*
         * u = Wn;
         */
        mlfAssign(&u, mclVa(Wn, "Wn"));
    /*
     * end
     */
    }
    /*
     * 
     * Bw=[];
     */
    mlfAssign(&Bw, _mxarray5_);
    /*
     * % step 2: convert to low-pass prototype estimate
     * if btype == 1	% lowpass
     */
    if (mclEqBool(mclVv(btype, "btype"), _mxarray6_)) {
        /*
         * Wn = u;
         */
        mlfAssign(&Wn, mclVv(u, "u"));
    /*
     * elseif btype == 2	% bandpass
     */
    } else if (mclEqBool(mclVv(btype, "btype"), _mxarray3_)) {
        /*
         * Bw = u(2) - u(1);
         */
        mlfAssign(
          &Bw,
          mclMinus(
            mclIntArrayRef1(mclVv(u, "u"), 2),
            mclIntArrayRef1(mclVv(u, "u"), 1)));
        /*
         * Wn = sqrt(u(1)*u(2));	% center frequency
         */
        mlfAssign(
          &Wn,
          mlfSqrt(
            mclMtimes(
              mclIntArrayRef1(mclVv(u, "u"), 1),
              mclIntArrayRef1(mclVv(u, "u"), 2))));
    /*
     * elseif btype == 3	% highpass
     */
    } else if (mclEqBool(mclVv(btype, "btype"), _mxarray7_)) {
        /*
         * Wn = u;
         */
        mlfAssign(&Wn, mclVv(u, "u"));
    /*
     * elseif btype == 4	% bandstop
     */
    } else if (mclEqBool(mclVv(btype, "btype"), _mxarray8_)) {
        /*
         * Bw = u(2) - u(1);
         */
        mlfAssign(
          &Bw,
          mclMinus(
            mclIntArrayRef1(mclVv(u, "u"), 2),
            mclIntArrayRef1(mclVv(u, "u"), 1)));
        /*
         * Wn = sqrt(u(1)*u(2));	% center frequency
         */
        mlfAssign(
          &Wn,
          mlfSqrt(
            mclMtimes(
              mclIntArrayRef1(mclVv(u, "u"), 1),
              mclIntArrayRef1(mclVv(u, "u"), 2))));
    /*
     * end
     */
    }
    /*
     * 
     * % step 3: Get N-th order Butterworth analog lowpass prototype
     * [z,p,k] = buttap(n);
     */
    mlfAssign(z, mlfButtap(p, &k, mclVa(n, "n")));
    /*
     * 
     * % Transform to state-space
     * [a,b,c,d] = zp2ss(z,p,k);
     */
    mlfAssign(
      &a, mlfZp2ss(&b, &c, &d, mclVv(*z, "z"), mclVv(*p, "p"), mclVv(k, "k")));
    /*
     * 
     * % step 4: Transform to lowpass, bandpass, highpass, or bandstop of desired Wn
     * if btype == 1		% Lowpass
     */
    if (mclEqBool(mclVv(btype, "btype"), _mxarray6_)) {
        /*
         * [a,b,c,d] = lp2lp(a,b,c,d,Wn);
         */
        mlfAssign(
          &a,
          mlfLp2lp(
            &b,
            &c,
            &d,
            mclVv(a, "a"),
            mclVv(b, "b"),
            mclVv(c, "c"),
            mclVv(d, "d"),
            mclVa(Wn, "Wn")));
    /*
     * 
     * elseif btype == 2	% Bandpass
     */
    } else if (mclEqBool(mclVv(btype, "btype"), _mxarray3_)) {
        /*
         * [a,b,c,d] = lp2bp(a,b,c,d,Wn,Bw);
         */
        mlfAssign(
          &a,
          mlfLp2bp(
            &b,
            &c,
            &d,
            mclVv(a, "a"),
            mclVv(b, "b"),
            mclVv(c, "c"),
            mclVv(d, "d"),
            mclVa(Wn, "Wn"),
            mclVv(Bw, "Bw")));
    /*
     * 
     * elseif btype == 3	% Highpass
     */
    } else if (mclEqBool(mclVv(btype, "btype"), _mxarray7_)) {
        /*
         * [a,b,c,d] = lp2hp(a,b,c,d,Wn);
         */
        mlfAssign(
          &a,
          mlfLp2hp(
            &b,
            &c,
            &d,
            mclVv(a, "a"),
            mclVv(b, "b"),
            mclVv(c, "c"),
            mclVv(d, "d"),
            mclVa(Wn, "Wn")));
    /*
     * 
     * elseif btype == 4	% Bandstop
     */
    } else if (mclEqBool(mclVv(btype, "btype"), _mxarray8_)) {
        /*
         * [a,b,c,d] = lp2bs(a,b,c,d,Wn,Bw);
         */
        mlfAssign(
          &a,
          mlfLp2bs(
            &b,
            &c,
            &d,
            mclVv(a, "a"),
            mclVv(b, "b"),
            mclVv(c, "c"),
            mclVv(d, "d"),
            mclVa(Wn, "Wn"),
            mclVv(Bw, "Bw")));
    /*
     * end
     */
    }
    /*
     * 
     * % step 5: Use Bilinear transformation to find discrete equivalent:
     * if ~analog,
     */
    if (mclNotBool(mclVv(analog, "analog"))) {
        /*
         * [a,b,c,d] = bilinear(a,b,c,d,fs);
         */
        mlfAssign(
          &a,
          mlfNBilinear(
            4,
            &b,
            &c,
            &d,
            mclVv(a, "a"),
            mclVv(b, "b"),
            mclVv(c, "c"),
            mclVv(d, "d"),
            mclVv(fs, "fs"),
            NULL));
    /*
     * end
     */
    }
    /*
     * 
     * if nargout == 4
     */
    if (nargout_ == 4) {
        /*
         * num = a;
         */
        mlfAssign(&num, mclVv(a, "a"));
        /*
         * den = b;
         */
        mlfAssign(den, mclVv(b, "b"));
        /*
         * z = c;
         */
        mlfAssign(z, mclVv(c, "c"));
        /*
         * p = d;
         */
        mlfAssign(p, mclVv(d, "d"));
    /*
     * else	% nargout <= 3
     */
    } else {
        /*
         * % Transform to zero-pole-gain and polynomial forms:
         * if nargout == 3
         */
        if (nargout_ == 3) {
            /*
             * [z,p,k] = ss2zp(a,b,c,d,1);
             */
            mlfAssign(
              z,
              mlfSs2zp(
                p,
                &k,
                mclVv(a, "a"),
                mclVv(b, "b"),
                mclVv(c, "c"),
                mclVv(d, "d"),
                _mxarray6_));
            /*
             * z = buttzeros(btype,n,Wn,Bw,analog);
             */
            mlfAssign(
              z,
              mlfButter_buttzeros(
                mclVv(btype, "btype"),
                mclVa(n, "n"),
                mclVa(Wn, "Wn"),
                mclVv(Bw, "Bw"),
                mclVv(analog, "analog")));
            /*
             * num = z;
             */
            mlfAssign(&num, mclVv(*z, "z"));
            /*
             * den = p;
             */
            mlfAssign(den, mclVv(*p, "p"));
            /*
             * z = k;
             */
            mlfAssign(z, mclVv(k, "k"));
        /*
         * else % nargout <= 2
         */
        } else {
            /*
             * den = poly(a);
             */
            mlfAssign(den, mlfPoly(mclVv(a, "a")));
            /*
             * num = buttnum(btype,n,Wn,Bw,analog,den);
             */
            mlfAssign(
              &num,
              mlfButter_buttnum(
                mclVv(btype, "btype"),
                mclVa(n, "n"),
                mclVa(Wn, "Wn"),
                mclVv(Bw, "Bw"),
                mclVv(analog, "analog"),
                mclVv(*den, "den")));
        /*
         * % num = poly(a-b*c)+(d-1)*den;
         * 
         * end
         */
        }
    /*
     * end
     */
    }
    mclValidateOutput(num, 1, nargout_, "num", "butter");
    mclValidateOutput(*den, 2, nargout_, "den", "butter");
    mclValidateOutput(*z, 3, nargout_, "z", "butter");
    mclValidateOutput(*p, 4, nargout_, "p", "butter");
    mxDestroyArray(btype);
    mxDestroyArray(analog);
    mxDestroyArray(errStr);
    mxDestroyArray(ans);
    mxDestroyArray(fs);
    mxDestroyArray(u);
    mxDestroyArray(Bw);
    mxDestroyArray(k);
    mxDestroyArray(a);
    mxDestroyArray(b);
    mxDestroyArray(c);
    mxDestroyArray(d);
    mxDestroyArray(varargin);
    mxDestroyArray(Wn);
    mxDestroyArray(n);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return num;
    /*
     * 
     * %---------------------------------
     */
}

/*
 * The function "Mbutter_buttnum" is the implementation version of the
 * "butter/buttnum" M-function from file
 * "c:\matlab65\toolbox\signal\signal\butter.m" (lines 115-157). It contains
 * the actual compiled code for that M-function. It is a static function and
 * must only be called from one of the interface functions, appearing below.
 */
/*
 * function b = buttnum(btype,n,Wn,Bw,analog,den)
 */
static mxArray * Mbutter_buttnum(int nargout_,
                                 mxArray * btype,
                                 mxArray * n,
                                 mxArray * Wn,
                                 mxArray * Bw,
                                 mxArray * analog,
                                 mxArray * den) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_butter);
    mxArray * b = NULL;
    mxArray * kern = NULL;
    mxArray * w = NULL;
    mxArray * r = NULL;
    mclCopyArray(&btype);
    mclCopyArray(&n);
    mclCopyArray(&Wn);
    mclCopyArray(&Bw);
    mclCopyArray(&analog);
    mclCopyArray(&den);
    /*
     * % This internal function returns more exact numerator vectors
     * % for the num/den case.
     * % Wn input is two element band edge vector
     * if analog
     */
    if (mlfTobool(mclVa(analog, "analog"))) {
        /*
         * switch btype
         */
        mxArray * v_ = mclInitialize(mclVa(btype, "btype"));
        if (mclSwitchCompare(v_, _mxarray6_)) {
            /*
             * case 1  % lowpass
             * b = [zeros(1,n) n^(-n)];
             */
            mlfAssign(
              &b,
              mlfHorzcat(
                mlfZeros(_mxarray6_, mclVa(n, "n"), NULL),
                mclMpower(mclVa(n, "n"), mclUminus(mclVa(n, "n"))),
                NULL));
            /*
             * b = real( b*polyval(den,-j*0)/polyval(b,-j*0) );
             */
            mlfAssign(
              &b,
              mlfReal(
                mclMrdivide(
                  mclMtimes(
                    mclVv(b, "b"),
                    mlfNPolyval(
                      1, NULL, mclVa(den, "den"), _mxarray9_, NULL, NULL)),
                  mlfNPolyval(
                    1, NULL, mclVv(b, "b"), _mxarray9_, NULL, NULL))));
        /*
         * case 2  % bandpass
         */
        } else if (mclSwitchCompare(v_, _mxarray3_)) {
            /*
             * b = [zeros(1,n) Bw^n zeros(1,n)];
             */
            mlfAssign(
              &b,
              mlfHorzcat(
                mlfZeros(_mxarray6_, mclVa(n, "n"), NULL),
                mclMpower(mclVa(Bw, "Bw"), mclVa(n, "n")),
                mlfZeros(_mxarray6_, mclVa(n, "n"), NULL),
                NULL));
            /*
             * b = real( b*polyval(den,-j*Wn)/polyval(b,-j*Wn) );
             */
            mlfAssign(
              &b,
              mlfReal(
                mclMrdivide(
                  mclMtimes(
                    mclVv(b, "b"),
                    mlfNPolyval(
                      1,
                      NULL,
                      mclVa(den, "den"),
                      mclMtimes(_mxarray10_, mclVa(Wn, "Wn")),
                      NULL,
                      NULL)),
                  mlfNPolyval(
                    1,
                    NULL,
                    mclVv(b, "b"),
                    mclMtimes(_mxarray10_, mclVa(Wn, "Wn")),
                    NULL,
                    NULL))));
        /*
         * case 3  % highpass
         */
        } else if (mclSwitchCompare(v_, _mxarray7_)) {
            /*
             * b = [1 zeros(1,n)];
             */
            mlfAssign(
              &b,
              mlfHorzcat(
                _mxarray6_, mlfZeros(_mxarray6_, mclVa(n, "n"), NULL), NULL));
            /*
             * b = real( b*den(1)/b(1) );
             */
            mlfAssign(
              &b,
              mlfReal(
                mclMrdivide(
                  mclMtimes(
                    mclVv(b, "b"), mclIntArrayRef1(mclVa(den, "den"), 1)),
                  mclIntArrayRef1(mclVv(b, "b"), 1))));
        /*
         * case 4  % bandstop
         */
        } else if (mclSwitchCompare(v_, _mxarray8_)) {
            /*
             * r = j*Wn*((-1).^(0:2*n-1)');
             */
            mlfAssign(
              &r,
              mlf_times_transpose(
                mclMtimes(_mxarray11_, mclVa(Wn, "Wn")),
                mlfPower(
                  _mxarray12_,
                  mlfColon(
                    _mxarray9_,
                    mclMinus(mclMtimes(_mxarray3_, mclVa(n, "n")), _mxarray6_),
                    NULL)),
                _mxarray3_));
            /*
             * b = poly(r);
             */
            mlfAssign(&b, mlfPoly(mclVv(r, "r")));
            /*
             * b = real( b*polyval(den,-j*0)/polyval(b,-j*0) );
             */
            mlfAssign(
              &b,
              mlfReal(
                mclMrdivide(
                  mclMtimes(
                    mclVv(b, "b"),
                    mlfNPolyval(
                      1, NULL, mclVa(den, "den"), _mxarray9_, NULL, NULL)),
                  mlfNPolyval(
                    1, NULL, mclVv(b, "b"), _mxarray9_, NULL, NULL))));
        /*
         * end
         */
        }
        mxDestroyArray(v_);
    /*
     * else
     */
    } else {
        /*
         * Wn = 2*atan2(Wn,4);
         */
        mlfAssign(
          &Wn, mclMtimes(_mxarray3_, mlfAtan2(mclVa(Wn, "Wn"), _mxarray8_)));
        /*
         * switch btype
         */
        {
            mxArray * v_ = mclInitialize(mclVa(btype, "btype"));
            if (mclSwitchCompare(v_, _mxarray6_)) {
                /*
                 * case 1  % lowpass
                 * r = -ones(n,1);
                 */
                mlfAssign(
                  &r, mclUminus(mlfOnes(mclVa(n, "n"), _mxarray6_, NULL)));
                /*
                 * w = 0;
                 */
                mlfAssign(&w, _mxarray9_);
            /*
             * case 2  % bandpass
             */
            } else if (mclSwitchCompare(v_, _mxarray3_)) {
                /*
                 * r = [ones(n,1); -ones(n,1)];
                 */
                mlfAssign(
                  &r,
                  mlfVertcat(
                    mlfOnes(mclVa(n, "n"), _mxarray6_, NULL),
                    mclUminus(mlfOnes(mclVa(n, "n"), _mxarray6_, NULL)),
                    NULL));
                /*
                 * w = Wn;
                 */
                mlfAssign(&w, mclVa(Wn, "Wn"));
            /*
             * case 3  % highpass
             */
            } else if (mclSwitchCompare(v_, _mxarray7_)) {
                /*
                 * r = ones(n,1);
                 */
                mlfAssign(&r, mlfOnes(mclVa(n, "n"), _mxarray6_, NULL));
                /*
                 * w = pi;
                 */
                mlfAssign(&w, _mxarray4_);
            /*
             * case 4  % bandstop
             */
            } else if (mclSwitchCompare(v_, _mxarray8_)) {
                /*
                 * r = exp(j*Wn*( (-1).^(0:2*n-1)' ));
                 */
                mlfAssign(
                  &r,
                  mlfExp(
                    mlf_times_transpose(
                      mclMtimes(_mxarray11_, mclVa(Wn, "Wn")),
                      mlfPower(
                        _mxarray12_,
                        mlfColon(
                          _mxarray9_,
                          mclMinus(
                            mclMtimes(_mxarray3_, mclVa(n, "n")), _mxarray6_),
                          NULL)),
                      _mxarray3_)));
                /*
                 * w = 0;
                 */
                mlfAssign(&w, _mxarray9_);
            /*
             * end
             */
            }
            mxDestroyArray(v_);
        }
        /*
         * b = poly(r);
         */
        mlfAssign(&b, mlfPoly(mclVv(r, "r")));
        /*
         * % now normalize so |H(w)| == 1:
         * kern = exp(-j*w*(0:length(b)-1));
         */
        mlfAssign(
          &kern,
          mlfExp(
            mclMtimes(
              mclMtimes(_mxarray10_, mclVv(w, "w")),
              mlfColon(
                _mxarray9_,
                mlfScalar(mclLengthInt(mclVv(b, "b")) - 1),
                NULL))));
        /*
         * b = real(b*(kern*den(:))/(kern*b(:)));
         */
        mlfAssign(
          &b,
          mlfReal(
            mclMrdivide(
              mclMtimes(
                mclVv(b, "b"),
                mclMtimes(
                  mclVv(kern, "kern"),
                  mclArrayRef1(mclVa(den, "den"), mlfCreateColonIndex()))),
              mclMtimes(
                mclVv(kern, "kern"),
                mclArrayRef1(mclVv(b, "b"), mlfCreateColonIndex())))));
    /*
     * end
     */
    }
    mclValidateOutput(b, 1, nargout_, "b", "butter/buttnum");
    mxDestroyArray(r);
    mxDestroyArray(w);
    mxDestroyArray(kern);
    mxDestroyArray(den);
    mxDestroyArray(analog);
    mxDestroyArray(Bw);
    mxDestroyArray(Wn);
    mxDestroyArray(n);
    mxDestroyArray(btype);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return b;
    /*
     * 
     */
}

/*
 * The function "Mbutter_buttzeros" is the implementation version of the
 * "butter/buttzeros" M-function from file
 * "c:\matlab65\toolbox\signal\signal\butter.m" (lines 157-187). It contains
 * the actual compiled code for that M-function. It is a static function and
 * must only be called from one of the interface functions, appearing below.
 */
/*
 * function z = buttzeros(btype,n,Wn,Bw,analog)
 */
static mxArray * Mbutter_buttzeros(int nargout_,
                                   mxArray * btype,
                                   mxArray * n,
                                   mxArray * Wn,
                                   mxArray * Bw,
                                   mxArray * analog) {
    mexLocalFunctionTable save_local_function_table_
      = mclSetCurrentLocalFunctionTable(&_local_function_table_butter);
    mxArray * z = NULL;
    mclCopyArray(&btype);
    mclCopyArray(&n);
    mclCopyArray(&Wn);
    mclCopyArray(&Bw);
    mclCopyArray(&analog);
    /*
     * % This internal function returns more exact zeros.
     * % Wn input is two element band edge vector
     * if analog
     */
    if (mlfTobool(mclVa(analog, "analog"))) {
        /*
         * % for lowpass and bandpass, don't include zeros at +Inf or -Inf
         * switch btype
         */
        mxArray * v_ = mclInitialize(mclVa(btype, "btype"));
        if (mclSwitchCompare(v_, _mxarray6_)) {
            /*
             * case 1  % lowpass
             * z = zeros(0,1);
             */
            mlfAssign(&z, mlfZeros(_mxarray9_, _mxarray6_, NULL));
        /*
         * case 2  % bandpass
         */
        } else if (mclSwitchCompare(v_, _mxarray3_)) {
            /*
             * z = zeros(n,1);
             */
            mlfAssign(&z, mlfZeros(mclVa(n, "n"), _mxarray6_, NULL));
        /*
         * case 3  % highpass
         */
        } else if (mclSwitchCompare(v_, _mxarray7_)) {
            /*
             * z = zeros(n,1);
             */
            mlfAssign(&z, mlfZeros(mclVa(n, "n"), _mxarray6_, NULL));
        /*
         * case 4  % bandstop
         */
        } else if (mclSwitchCompare(v_, _mxarray8_)) {
            /*
             * z = j*Wn*((-1).^(0:2*n-1)');
             */
            mlfAssign(
              &z,
              mlf_times_transpose(
                mclMtimes(_mxarray11_, mclVa(Wn, "Wn")),
                mlfPower(
                  _mxarray12_,
                  mlfColon(
                    _mxarray9_,
                    mclMinus(mclMtimes(_mxarray3_, mclVa(n, "n")), _mxarray6_),
                    NULL)),
                _mxarray3_));
        /*
         * end
         */
        }
        mxDestroyArray(v_);
    /*
     * else
     */
    } else {
        /*
         * Wn = 2*atan2(Wn,4);
         */
        mlfAssign(
          &Wn, mclMtimes(_mxarray3_, mlfAtan2(mclVa(Wn, "Wn"), _mxarray8_)));
        /*
         * switch btype
         */
        {
            mxArray * v_ = mclInitialize(mclVa(btype, "btype"));
            if (mclSwitchCompare(v_, _mxarray6_)) {
                /*
                 * case 1  % lowpass
                 * z = -ones(n,1);
                 */
                mlfAssign(
                  &z, mclUminus(mlfOnes(mclVa(n, "n"), _mxarray6_, NULL)));
            /*
             * case 2  % bandpass
             */
            } else if (mclSwitchCompare(v_, _mxarray3_)) {
                /*
                 * z = [ones(n,1); -ones(n,1)];
                 */
                mlfAssign(
                  &z,
                  mlfVertcat(
                    mlfOnes(mclVa(n, "n"), _mxarray6_, NULL),
                    mclUminus(mlfOnes(mclVa(n, "n"), _mxarray6_, NULL)),
                    NULL));
            /*
             * case 3  % highpass
             */
            } else if (mclSwitchCompare(v_, _mxarray7_)) {
                /*
                 * z = ones(n,1);
                 */
                mlfAssign(&z, mlfOnes(mclVa(n, "n"), _mxarray6_, NULL));
            /*
             * case 4  % bandstop
             */
            } else if (mclSwitchCompare(v_, _mxarray8_)) {
                /*
                 * z = exp(j*Wn*( (-1).^(0:2*n-1)' ));
                 */
                mlfAssign(
                  &z,
                  mlfExp(
                    mlf_times_transpose(
                      mclMtimes(_mxarray11_, mclVa(Wn, "Wn")),
                      mlfPower(
                        _mxarray12_,
                        mlfColon(
                          _mxarray9_,
                          mclMinus(
                            mclMtimes(_mxarray3_, mclVa(n, "n")), _mxarray6_),
                          NULL)),
                      _mxarray3_)));
            /*
             * end
             */
            }
            mxDestroyArray(v_);
        }
    /*
     * end
     */
    }
    mclValidateOutput(z, 1, nargout_, "z", "butter/buttzeros");
    mxDestroyArray(analog);
    mxDestroyArray(Bw);
    mxDestroyArray(Wn);
    mxDestroyArray(n);
    mxDestroyArray(btype);
    mclSetCurrentLocalFunctionTable(save_local_function_table_);
    return z;
    /*
     * 
     * 
     */
}
